/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ElementValuePairGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class AnnotationEntryGen {
    private int typeIndex;
    private List<ElementValuePairGen> evs;
    private final ConstantPoolGen cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationEntryGen(AnnotationEntry annotationEntry, ConstantPoolGen constantPoolGen, boolean bl) {
        this.cpool = constantPoolGen;
        this.typeIndex = bl ? constantPoolGen.addUtf8(annotationEntry.getAnnotationType()) : annotationEntry.getAnnotationTypeIndex();
        this.isRuntimeVisible = annotationEntry.isRuntimeVisible();
        this.evs = this.copyValues(annotationEntry.getElementValuePairs(), constantPoolGen, bl);
    }

    private List<ElementValuePairGen> copyValues(ElementValuePair[] elementValuePairArray, ConstantPoolGen constantPoolGen, boolean bl) {
        ArrayList<ElementValuePairGen> arrayList = new ArrayList<ElementValuePairGen>();
        for (ElementValuePair elementValuePair : elementValuePairArray) {
            arrayList.add(new ElementValuePairGen(elementValuePair, constantPoolGen, bl));
        }
        return arrayList;
    }

    private AnnotationEntryGen(ConstantPoolGen constantPoolGen) {
        this.cpool = constantPoolGen;
    }

    public AnnotationEntry getAnnotation() {
        AnnotationEntry annotationEntry = new AnnotationEntry(this.typeIndex, this.cpool.getConstantPool(), this.isRuntimeVisible);
        for (ElementValuePairGen elementValuePairGen : this.evs) {
            annotationEntry.addElementNameValuePair(elementValuePairGen.getElementNameValuePair());
        }
        return annotationEntry;
    }

    public AnnotationEntryGen(ObjectType objectType, List<ElementValuePairGen> list, boolean bl, ConstantPoolGen constantPoolGen) {
        this.cpool = constantPoolGen;
        this.typeIndex = constantPoolGen.addUtf8(objectType.getSignature());
        this.evs = list;
        this.isRuntimeVisible = bl;
    }

    public static AnnotationEntryGen read(DataInput dataInput, ConstantPoolGen constantPoolGen, boolean bl) throws IOException {
        AnnotationEntryGen annotationEntryGen = new AnnotationEntryGen(constantPoolGen);
        annotationEntryGen.typeIndex = dataInput.readUnsignedShort();
        int n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readUnsignedShort();
            annotationEntryGen.addElementNameValuePair(new ElementValuePairGen(n2, ElementValueGen.readElementValue(dataInput, constantPoolGen), constantPoolGen));
        }
        annotationEntryGen.isRuntimeVisible(bl);
        return annotationEntryGen;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.typeIndex);
        dataOutputStream.writeShort(this.evs.size());
        for (ElementValuePairGen elementValuePairGen : this.evs) {
            elementValuePairGen.dump(dataOutputStream);
        }
    }

    public void addElementNameValuePair(ElementValuePairGen elementValuePairGen) {
        if (this.evs == null) {
            this.evs = new ArrayList<ElementValuePairGen>();
        }
        this.evs.add(elementValuePairGen);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public final String getTypeSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return constantUtf8.getBytes();
    }

    public final String getTypeName() {
        return this.getTypeSignature();
    }

    public List<ElementValuePairGen> getValues() {
        return this.evs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("AnnotationGen:[").append(this.getTypeName()).append(" #").append(this.evs.size()).append(" {");
        for (int i = 0; i < this.evs.size(); ++i) {
            stringBuilder.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@").append(this.getTypeName()).append("(");
        for (int i = 0; i < this.evs.size(); ++i) {
            stringBuilder.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void isRuntimeVisible(boolean bl) {
        this.isRuntimeVisible = bl;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    static Attribute[] getAnnotationAttributes(ConstantPoolGen constantPoolGen, AnnotationEntryGen[] annotationEntryGenArray) {
        if (annotationEntryGenArray.length == 0) {
            return new Attribute[0];
        }
        try {
            int n = 0;
            int n2 = 0;
            for (AnnotationEntryGen object2 : annotationEntryGenArray) {
                if (object2.isRuntimeVisible()) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            Throwable throwable = null;
            try (Object object3 = new DataOutputStream(byteArrayOutputStream);
                 DataOutputStream n3 = new DataOutputStream(byteArrayOutputStream2);){
                ((DataOutputStream)object3).writeShort(n);
                n3.writeShort(n2);
                for (AnnotationEntryGen annotationEntryGen : annotationEntryGenArray) {
                    if (annotationEntryGen.isRuntimeVisible()) {
                        annotationEntryGen.dump((DataOutputStream)object3);
                        continue;
                    }
                    annotationEntryGen.dump(n3);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            object3 = byteArrayOutputStream.toByteArray();
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            int n3 = -1;
            int n4 = -1;
            if (((Object)object3).length > 2) {
                n3 = constantPoolGen.addUtf8("RuntimeVisibleAnnotations");
            }
            if (byArray.length > 2) {
                n4 = constantPoolGen.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList arrayList = new ArrayList();
            if (((Object)object3).length > 2) {
                arrayList.add(new RuntimeVisibleAnnotations(n3, ((Object)object3).length, new DataInputStream(new ByteArrayInputStream((byte[])object3)), constantPoolGen.getConstantPool()));
            }
            if (byArray.length > 2) {
                arrayList.add(new RuntimeInvisibleAnnotations(n4, byArray.length, new DataInputStream(new ByteArrayInputStream(byArray)), constantPoolGen.getConstantPool()));
            }
            return arrayList.toArray(new Attribute[arrayList.size()]);
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing annotations. " + iOException.getMessage());
            return null;
        }
    }

    static Attribute[] getParameterAnnotationAttributes(ConstantPoolGen constantPoolGen, List<AnnotationEntryGen>[] listArray) {
        int[] nArray = new int[listArray.length];
        int n = 0;
        int[] nArray2 = new int[listArray.length];
        int n2 = 0;
        try {
            int n3;
            for (int i = 0; i < listArray.length; ++i) {
                if (listArray[i] == null) continue;
                for (AnnotationEntryGen object22 : listArray[i]) {
                    if (object22.isRuntimeVisible()) {
                        int n4 = i;
                        nArray[n4] = nArray[n4] + 1;
                        ++n;
                        continue;
                    }
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] + 1;
                    ++n2;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Throwable throwable = null;
            try (Object object3 = new DataOutputStream(byteArrayOutputStream);){
                ((DataOutputStream)object3).writeByte(listArray.length);
                for (int i = 0; i < listArray.length; ++i) {
                    ((DataOutputStream)object3).writeShort(nArray[i]);
                    if (nArray[i] <= 0) continue;
                    for (AnnotationEntryGen annotationEntryGen : listArray[i]) {
                        if (!annotationEntryGen.isRuntimeVisible()) continue;
                        annotationEntryGen.dump((DataOutputStream)object3);
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            object3 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object3);
            Object object = null;
            try {
                dataOutputStream.writeByte(listArray.length);
                for (int i = 0; i < listArray.length; ++i) {
                    dataOutputStream.writeShort(nArray2[i]);
                    if (nArray2[i] <= 0) continue;
                    for (AnnotationEntryGen annotationEntryGen : listArray[i]) {
                        if (annotationEntryGen.isRuntimeVisible()) continue;
                        annotationEntryGen.dump(dataOutputStream);
                    }
                }
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw throwable4;
            }
            finally {
                if (dataOutputStream != null) {
                    if (object != null) {
                        try {
                            dataOutputStream.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                    } else {
                        dataOutputStream.close();
                    }
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = ((ByteArrayOutputStream)object3).toByteArray();
            int n6 = -1;
            int n7 = -1;
            if (n > 0) {
                n6 = constantPoolGen.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (n2 > 0) {
                n3 = constantPoolGen.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<ParameterAnnotations> arrayList = new ArrayList<ParameterAnnotations>();
            if (n > 0) {
                arrayList.add(new RuntimeVisibleParameterAnnotations(n6, byArray.length, new DataInputStream(new ByteArrayInputStream(byArray)), constantPoolGen.getConstantPool()));
            }
            if (n2 > 0) {
                arrayList.add(new RuntimeInvisibleParameterAnnotations(n3, ((Object)object).length, new DataInputStream(new ByteArrayInputStream((byte[])object)), constantPoolGen.getConstantPool()));
            }
            return arrayList.toArray(new Attribute[arrayList.size()]);
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing parameter annotations." + iOException.getMessage());
            return null;
        }
    }
}

